Provides a vastly more customizable work tab.

![Important](https://headers.karel-kroeze.nl/title/Important.png)  

Work Tab completely takes over job priorities from the vanilla game. In order to support core functionalities and other mods, it intercepts calls to get/set priorities. However, when it is told to set priorities by other modded code that is not aware of the time schedule or detailed priorities, the priority will be set for the whole day, and/or for all workgivers in a worktype.

![Features](https://headers.karel-kroeze.nl/title/Features.png)  

Various usability extentions to the 'vanilla' work tab;

- Work types can be expanded (by Ctrl+clicking the column header) to allow you to set priorities for the individual tasks within each work type.
- Time scheduler to set priorities for a given time slot only - allowing you to designate a cleaning hour, or have your cook prepare meals right before dinner, etc. etc.
- Up to 9 priority levels (configurable in mod options)
- Various small UX tweaks; scrolling to increase/decrease/toggle priorities, increase/decrease priorities for whole columns/rows (by holding shift and clicking/scrolling while hovering over the column header/pawn name respectively).
- _All functions are detailed in the tooltips, take a moment to hover over and read them!_

![Known Issues](https://headers.karel-kroeze.nl/title/Known%20Issues.png)  

- `"Star Wars -- The Force"` versions prior to 1.21.1 cause priorities to reset for force users. **THIS INCLUDES THE CURRENT STEAM VERSION OF STAR WARS -- THE FORCE!** (as of 25/3/20). There is an official update available by one of the collaborators on the mod on [GitHub](https://github.com/jecrell/Star-Wars---The-Force/releases).

- `Better Pawn Control` has added support for `Work Tab` and `Animal Tab`, but there currently (as of 27/7/21) still is an issue where work settings may reset.

![Notes](https://headers.karel-kroeze.nl/title/Notes.png)  

With great power comes great responsibility. The default priorities of tasks within a job is set for a good reason; it's (usually) a sensible default. Changing these can lead to deadlock situations, so change the priorities of individual jobs at your own risk!

Finally, there will never be an 'autolabour' mode where a mod sets priorities for you. Due to the way the AI is handled (e.g. pawns actively look for work, instead of there being a 'bulletin board' of jobs that need doing), it's not feasible to get the complete list of work that needs doing that would be needed to make this a reality, without extreme overhead and loads of special exception coding.

![Powered by Harmony](https://headers.karel-kroeze.nl/title/Powered%20by%20Harmony.png)  

![Powered by Harmony](https://raw.githubusercontent.com/pardeike/Harmony/master/HarmonyLogo.png)

![Think you found a bug?](https://headers.karel-kroeze.nl/title/Think%20you%20found%20a%20bug%3F.png)  

Please read [this guide](http://steamcommunity.com/sharedfiles/filedetails/?id=725234314) before creating a bug report,
and then create a bug report [here](https://github.com/fluffy-mods/WorkTab/issues)

![Older versions](https://headers.karel-kroeze.nl/title/Older%20versions.png)  

All current and past versions of this mod can be downloaded from [GitHub](https://github.com/fluffy-mods/WorkTab/releases).

![License](https://headers.karel-kroeze.nl/title/License.png)  

All original code in this mod is licensed under the [MIT license](https://opensource.org/licenses/MIT). Do what you want, but give me credit.
All original content (e.g. text, imagery, sounds) in this mod is licensed under the [CC-BY-SA 4.0 license](http://creativecommons.org/licenses/by-sa/4.0/).

Parts of the code in this mod, and some of the content may be licensed by their original authors. If this is the case, the original author & license will either be given in the source code, or be in a LICENSE file next to the content. Please do not decompile my mods, but use the original source code available on [GitHub](https://github.com/fluffy-mods/WorkTab/), so license information in the source code is preserved.

Parts of this mod were created by, or derived from works created by;
- Freepik / flaticon.com: helmet preview image ([BY-NC](https://www.freepik.com/))


![Are you enjoying my mods?](https://headers.karel-kroeze.nl/title/Are%20you%20enjoying%20my%20mods%3F.png)  

Normally, this is where I ask you to show you appreciation by buying me a coffee.

These are not normal times. Ukraine is being invaded by Russia, at the whim of a ruthless dictator. Innocent people are loosing their lives, and fighting for their continued freedom.

This is not a matter of politics. This is not a debate. Putins' bloody campaign in Ukraine is illegal, and he will stop at nothing to get what he wants, when he wants it, no matter the cost. The Russian army is invading a country without provocation, bombing civilians and murdering innocents.

The prospect of waking up to see my country at war is alien to me, as it must have seemed to most Ukrainians. I can do little to influence the outcome of current affairs, but I will do whatever I can.

**I ask you to join me in supporting the people of Ukraine**

![Humanitarian Aid](https://headers.karel-kroeze.nl/title/Humanitarian%20Aid.png)  

If you can, donate to the various charities providing humanitarian aid. If you don't know where to donate, Global Citizen maintains a list of charitable organizations active in the region.

<https://www.globalcitizen.org/en/content/ways-to-help-ukraine-conflict/>

![Speak up](https://headers.karel-kroeze.nl/title/Speak%20up.png)  

Leaders around the world are deciding on how to respond to Putins' aggression. They are balancing their conscience, and their desire to be re-elected. Many are afraid to impose heavy sanctions because the economic repercussions might loose them votes. The Dutch government, my government, has hinted that they are unwilling to accept Ukranian refugees, and has played a part in allowing Russia to have continued access to international finance. I am ashamed of these actions, taken in my name.

Whereever your live, please let your government know you care more about supporting the people of Ukraine than you do about the price of gas. Join a protest, write letters, call your representatives, and show them that you care about justice!
